/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.raytracer;

import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.raytracer.ExtendedMOP;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class RayTracer {
    private Vector3 vec = new Vector3();
    private Vector3 vec2 = new Vector3();
    private Vector3 s_vec = new Vector3();
    private double s_dist;
    private int s_side;
    private IndexedCuboid6 c_cuboid;
    private static ThreadLocal<RayTracer> t_inst = new ThreadLocal();

    public static RayTracer instance() {
        RayTracer rayTracer = t_inst.get();
        if (rayTracer == null) {
            rayTracer = new RayTracer();
            t_inst.set(rayTracer);
        }
        return rayTracer;
    }

    private void traceSide(int n, Vector3 vector3, Vector3 vector32, Cuboid6 cuboid6) {
        this.vec.set(vector3);
        Vector3 vector33 = null;
        switch (n) {
            case 0: {
                vector33 = this.vec.XZintercept(vector32, cuboid6.min.y);
                break;
            }
            case 1: {
                vector33 = this.vec.XZintercept(vector32, cuboid6.max.y);
                break;
            }
            case 2: {
                vector33 = this.vec.XYintercept(vector32, cuboid6.min.z);
                break;
            }
            case 3: {
                vector33 = this.vec.XYintercept(vector32, cuboid6.max.z);
                break;
            }
            case 4: {
                vector33 = this.vec.YZintercept(vector32, cuboid6.min.x);
                break;
            }
            case 5: {
                vector33 = this.vec.YZintercept(vector32, cuboid6.max.x);
            }
        }
        if (vector33 == null) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid6.min.x, vector33.x, cuboid6.max.x) && MathHelper.between(cuboid6.min.z, vector33.z, cuboid6.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid6.min.x, vector33.x, cuboid6.max.x) && MathHelper.between(cuboid6.min.y, vector33.y, cuboid6.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid6.min.y, vector33.y, cuboid6.max.y) && MathHelper.between(cuboid6.min.z, vector33.z, cuboid6.max.z)) break;
                return;
            }
        }
        double d = this.vec2.set(vector33).subtract(vector3).magSquared();
        if (d < this.s_dist) {
            this.s_side = n;
            this.s_dist = d;
            this.s_vec.set(this.vec);
        }
    }

    public MovingObjectPosition rayTraceCuboid(Vector3 vector3, Vector3 vector32, Cuboid6 cuboid6) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        for (int i = 0; i < 6; ++i) {
            this.traceSide(i, vector3, vector32, cuboid6);
        }
        if (this.s_side < 0) {
            return null;
        }
        MovingObjectPosition movingObjectPosition = new MovingObjectPosition(0, 0, 0, this.s_side, this.s_vec.toVec3D());
        movingObjectPosition.typeOfHit = null;
        return movingObjectPosition;
    }

    public MovingObjectPosition rayTraceCuboid(Vector3 vector3, Vector3 vector32, Cuboid6 cuboid6, BlockCoord blockCoord) {
        MovingObjectPosition movingObjectPosition = this.rayTraceCuboid(vector3, vector32, cuboid6);
        if (movingObjectPosition != null) {
            movingObjectPosition.typeOfHit = MovingObjectPosition.MovingObjectType.BLOCK;
            movingObjectPosition.blockX = blockCoord.x;
            movingObjectPosition.blockY = blockCoord.y;
            movingObjectPosition.blockZ = blockCoord.z;
        }
        return movingObjectPosition;
    }

    public MovingObjectPosition rayTraceCuboid(Vector3 vector3, Vector3 vector32, Cuboid6 cuboid6, Entity entity) {
        MovingObjectPosition movingObjectPosition = this.rayTraceCuboid(vector3, vector32, cuboid6);
        if (movingObjectPosition != null) {
            movingObjectPosition.typeOfHit = MovingObjectPosition.MovingObjectType.ENTITY;
            movingObjectPosition.entityHit = entity;
        }
        return movingObjectPosition;
    }

    public MovingObjectPosition rayTraceCuboids(Vector3 vector3, Vector3 vector32, List<IndexedCuboid6> list) {
        double d = Double.MAX_VALUE;
        MovingObjectPosition movingObjectPosition = null;
        for (IndexedCuboid6 indexedCuboid6 : list) {
            MovingObjectPosition movingObjectPosition2 = this.rayTraceCuboid(vector3, vector32, indexedCuboid6);
            if (movingObjectPosition2 == null || !(this.s_dist < d)) continue;
            movingObjectPosition2 = new ExtendedMOP(movingObjectPosition2, indexedCuboid6.data, this.s_dist);
            d = this.s_dist;
            movingObjectPosition = movingObjectPosition2;
            this.c_cuboid = indexedCuboid6;
        }
        return movingObjectPosition;
    }

    public MovingObjectPosition rayTraceCuboids(Vector3 vector3, Vector3 vector32, List<IndexedCuboid6> list, BlockCoord blockCoord, Block block) {
        MovingObjectPosition movingObjectPosition = this.rayTraceCuboids(vector3, vector32, list);
        if (movingObjectPosition != null) {
            movingObjectPosition.typeOfHit = MovingObjectPosition.MovingObjectType.BLOCK;
            movingObjectPosition.blockX = blockCoord.x;
            movingObjectPosition.blockY = blockCoord.y;
            movingObjectPosition.blockZ = blockCoord.z;
            if (block != null) {
                this.c_cuboid.add(new Vector3(-blockCoord.x, -blockCoord.y, -blockCoord.z)).setBlockBounds(block);
            }
        }
        return movingObjectPosition;
    }

    public void rayTraceCuboids(Vector3 vector3, Vector3 vector32, List<IndexedCuboid6> list, BlockCoord blockCoord, Block block, List<ExtendedMOP> list2) {
        for (IndexedCuboid6 indexedCuboid6 : list) {
            MovingObjectPosition movingObjectPosition = this.rayTraceCuboid(vector3, vector32, indexedCuboid6);
            if (movingObjectPosition == null) continue;
            ExtendedMOP extendedMOP = new ExtendedMOP(movingObjectPosition, indexedCuboid6.data, this.s_dist);
            extendedMOP.typeOfHit = MovingObjectPosition.MovingObjectType.BLOCK;
            extendedMOP.blockX = blockCoord.x;
            extendedMOP.blockY = blockCoord.y;
            extendedMOP.blockZ = blockCoord.z;
            list2.add(extendedMOP);
        }
    }

    public static MovingObjectPosition retraceBlock(World world, EntityPlayer entityPlayer, int n, int n2, int n3) {
        Block block = world.getBlock(n, n2, n3);
        Vec3 vec3 = RayTracer.getCorrectedHeadVec(entityPlayer);
        Vec3 vec32 = entityPlayer.getLook(1.0f);
        double d = RayTracer.getBlockReachDistance(entityPlayer);
        Vec3 vec33 = vec3.addVector(vec32.xCoord * d, vec32.yCoord * d, vec32.zCoord * d);
        return block.collisionRayTrace(world, n, n2, n3, vec3, vec33);
    }

    private static double getBlockReachDistance_server(EntityPlayerMP entityPlayerMP) {
        return entityPlayerMP.theItemInWorldManager.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.getMinecraft().playerController.getBlockReachDistance();
    }

    public static MovingObjectPosition reTrace(World world, EntityPlayer entityPlayer) {
        return RayTracer.reTrace(world, entityPlayer, RayTracer.getBlockReachDistance(entityPlayer));
    }

    public static MovingObjectPosition reTrace(World world, EntityPlayer entityPlayer, double d) {
        Vec3 vec3 = RayTracer.getCorrectedHeadVec(entityPlayer);
        Vec3 vec32 = entityPlayer.getLook(1.0f);
        Vec3 vec33 = vec3.addVector(vec32.xCoord * d, vec32.yCoord * d, vec32.zCoord * d);
        return world.func_147447_a(vec3, vec33, true, false, true);
    }

    public static Vec3 getCorrectedHeadVec(EntityPlayer entityPlayer) {
        Vec3 vec3 = Vec3.createVectorHelper((double)entityPlayer.posX, (double)entityPlayer.posY, (double)entityPlayer.posZ);
        if (entityPlayer.worldObj.isRemote) {
            vec3.yCoord += (double)(entityPlayer.getEyeHeight() - entityPlayer.getDefaultEyeHeight());
        } else {
            vec3.yCoord += (double)entityPlayer.getEyeHeight();
            if (entityPlayer instanceof EntityPlayerMP && entityPlayer.isSneaking()) {
                vec3.yCoord -= 0.08;
            }
        }
        return vec3;
    }

    public static Vec3 getStartVec(EntityPlayer entityPlayer) {
        return RayTracer.getCorrectedHeadVec(entityPlayer);
    }

    public static double getBlockReachDistance(EntityPlayer entityPlayer) {
        return entityPlayer.worldObj.isRemote ? RayTracer.getBlockReachDistance_client() : (entityPlayer instanceof EntityPlayerMP ? RayTracer.getBlockReachDistance_server((EntityPlayerMP)entityPlayer) : 5.0);
    }

    public static Vec3 getEndVec(EntityPlayer entityPlayer) {
        Vec3 vec3 = RayTracer.getCorrectedHeadVec(entityPlayer);
        Vec3 vec32 = entityPlayer.getLook(1.0f);
        double d = RayTracer.getBlockReachDistance(entityPlayer);
        return vec3.addVector(vec32.xCoord * d, vec32.yCoord * d, vec32.zCoord * d);
    }
}

